<?php

namespace App\Workflows\Services;

use App\Workflows\Models\WorkflowTemplate;
use InvalidArgumentException;

/**
 * Validates that required steps are present in workflow templates
 */
class RequiredStepsValidator
{
    /**
     * Validate that all required steps are present
     *
     * @throws InvalidArgumentException
     */
    public function validate(WorkflowTemplate $template): void
    {
        $requiredSteps = config("workflows.required_steps.{$template->subject_type}", []);

        if (empty($requiredSteps)) {
            return;
        }

        $templateSteps = $template->stepTemplates()
            ->whereNotNull('system_key')
            ->pluck('system_key')
            ->toArray();

        $missingSteps = array_diff($requiredSteps, $templateSteps);

        if (! empty($missingSteps)) {
            throw new InvalidArgumentException(
                'Workflow template is missing required steps: '.implode(', ', $missingSteps)
            );
        }
    }
}
