<?php

namespace App\Workflows\Examples;

use App\Workflows\Actions\WorkflowActions;
use App\Workflows\Traits\HasWorkflow;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;

/**
 * Example: How to add workflow support to any model
 *
 * 1. Add the HasWorkflow trait to your model
 * 2. Add your model to the workflows.php config
 * 3. Use WorkflowActions in your Filament pages
 */

// Example Model Usage:
class ExampleModelWithWorkflow
{
    use HasWorkflow;

    // Your model automatically gets:
    // - workflowInstance() relationship
    // - currentStep() method
    // - hasWorkflow() method
    // - hasPendingStep() method
    // - getWorkflowStatusLabel() method
}

// Example Filament Page Usage:
class ViewExampleModel extends ViewRecord
{
    public function mount(int|string $record): void
    {
        parent::mount($record);

        // Auto-initialize workflow
        WorkflowActions::autoInitializeWorkflow($this->record);
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make(),
            // Add all workflow actions with one line
            ...WorkflowActions::getActions($this->record, fn ($keys) => $this->refreshFormData($keys)),
        ];
    }
}
