<?php

namespace App\Utils;

class ProgressBarRenderer
{
    /**
     * Render a progress bar with percentage and label
     *
     * @param  float  $percentage  The percentage value (0-100)
     * @param  string  $label  The label to display above the progress bar
     * @return string HTML string for the progress bar
     */
    public static function render(float $percentage, string $label): string
    {
        $percentage = max(0, min(100, $percentage)); // Ensure percentage is between 0 and 100
        $roundedPercentage = round($percentage, 1);

        // Determine color based on percentage (using hex colors instead of classes)
        $backgroundColor = match (true) {
            $percentage >= 80 => '#10b981', // green-500
            $percentage >= 60 => '#3b82f6', // blue-500
            $percentage >= 40 => '#eab308', // yellow-500
            $percentage >= 20 => '#f97316', // orange-500
            default => '#ef4444', // red-500
        };

        $textColor = match (true) {
            $percentage >= 80 => '#047857', // green-700
            $percentage >= 60 => '#1d4ed8', // blue-700
            $percentage >= 40 => '#a16207', // yellow-700
            $percentage >= 20 => '#c2410c', // orange-700
            default => '#dc2626', // red-700
        };

        return '
            <div style="margin-bottom: 1rem;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 0.5rem; gap: 5rem;">
                    <span style="font-size: 0.875rem; font-weight: 500; color: #374151;">'.$label.'</span>
                    <span style="font-size: 0.875rem; font-weight: bold; color: '.$textColor.';">'.$roundedPercentage.'%</span>
                </div>
                <div style="width: 100%; background-color: #e5e7eb; border-radius: 9999px; height: 12px;">
                    <div style="height: 12px; border-radius: 9999px; width: '.$percentage.'%; background-color: '.$backgroundColor.'; transition: all 0.5s ease-out;"></div>
                </div>
            </div>
        ';
    }
}
