<?php

namespace App\Traits;

use App\Models\Org;
use App\Models\Scopes\OrgScope;
use Filament\Facades\Filament;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

trait BelongsToOrg
{
    use SoftDeletes;

    public function org(): BelongsTo
    {
        return $this->belongsTo(Org::class);
    }

    public static function bootBelongsToOrg()
    {
        static::addGlobalScope(new OrgScope);
    }

    // on insert make sure org_id is set
    protected static function booted()
    {
        static::creating(function ($model) {
            if (Filament::getTenant()) {
                $model->org()->associate(Filament::getTenant());
            }
        });
    }
}
