<?php

namespace App\Providers\Filament;

use App\Http\Middleware\EnsureUserHasAssociation;
use App\Models\Org;
use Archilex\AdvancedTables\Plugin\AdvancedTablesPlugin;
use BezhanSalleh\FilamentShield\FilamentShieldPlugin;
use BezhanSalleh\FilamentShield\Middleware\SyncShieldTenant;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\AuthenticateSession;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Pages\Dashboard;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Widgets\AccountWidget;
use Filament\Widgets\FilamentInfoWidget;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use RalphJSmit\Filament\Activitylog\FilamentActivitylog;

class AssociationPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->id('association')
            ->path('association')
            ->login()
            ->tenant(Org::class)
            ->viteTheme('resources/css/filament/admin/theme.css')
            ->brandLogo(asset('images/sadu-full-logo.svg'))
            ->discoverResources(in: app_path('Filament/Association/Resources'), for: 'App\Filament\Association\Resources')
            ->discoverPages(in: app_path('Filament/Association/Pages'), for: 'App\Filament\Association\Pages')
            ->pages([
                Dashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Association/Widgets'), for: 'App\Filament\Association\Widgets')
            ->widgets([
                AccountWidget::class,
                FilamentInfoWidget::class,
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->plugins([
                FilamentShieldPlugin::make(),
                AdvancedTablesPlugin::make()
                    ->tenant(Org::class),
                FilamentActivitylog::make(),
            ])
            ->tenantMiddleware([
                SyncShieldTenant::class,
                EnsureUserHasAssociation::class,
            ], isPersistent: true)
            ->authMiddleware([
                Authenticate::class,
            ])
            ->darkMode(false)
            ->sidebarCollapsibleOnDesktop()
            ->globalSearch(false)
            ->colors([
                'primary' => Color::generateV3Palette('#DE7D3C'),
                'danger' => Color::generateV3Palette('#67272C'),
                'gray' => Color::generateV3Palette('#64748B'),
                'info' => Color::generateV3Palette('#2F80ED'),
                'success' => Color::generateV3Palette('#42C75E'),
                'warning' => Color::generateV3Palette('#FBBF24'),
            ]);
    }
}
