<?php

declare(strict_types=1);

namespace App\Policies;

use Archilex\AdvancedTables\Models\UserView;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Foundation\Auth\User as AuthUser;

class UserViewPolicy
{
    use HandlesAuthorization;

    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:UserView');
    }

    public function view(AuthUser $authUser, UserView $userView): bool
    {
        return $authUser->can('View:UserView');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:UserView');
    }

    public function update(AuthUser $authUser, UserView $userView): bool
    {
        return $authUser->can('Update:UserView');
    }

    public function delete(AuthUser $authUser, UserView $userView): bool
    {
        return $authUser->can('Delete:UserView');
    }

    public function restore(AuthUser $authUser, UserView $userView): bool
    {
        return $authUser->can('Restore:UserView');
    }

    public function forceDelete(AuthUser $authUser, UserView $userView): bool
    {
        return $authUser->can('ForceDelete:UserView');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:UserView');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:UserView');
    }

    public function replicate(AuthUser $authUser, UserView $userView): bool
    {
        return $authUser->can('Replicate:UserView');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:UserView');
    }
}
