<?php

declare(strict_types=1);

namespace App\Policies;

use App\Models\ProjectCharter;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Foundation\Auth\User as AuthUser;

class ProjectCharterPolicy
{
    use HandlesAuthorization;

    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:ProjectCharter');
    }

    public function view(AuthUser $authUser, ProjectCharter $projectCharter): bool
    {
        return $authUser->can('View:ProjectCharter');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:ProjectCharter');
    }

    public function update(AuthUser $authUser, ProjectCharter $projectCharter): bool
    {
        return $authUser->can('Update:ProjectCharter');
    }

    public function delete(AuthUser $authUser, ProjectCharter $projectCharter): bool
    {
        return $authUser->can('Delete:ProjectCharter');
    }

    public function restore(AuthUser $authUser, ProjectCharter $projectCharter): bool
    {
        return $authUser->can('Restore:ProjectCharter');
    }

    public function forceDelete(AuthUser $authUser, ProjectCharter $projectCharter): bool
    {
        return $authUser->can('ForceDelete:ProjectCharter');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:ProjectCharter');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:ProjectCharter');
    }

    public function replicate(AuthUser $authUser, ProjectCharter $projectCharter): bool
    {
        return $authUser->can('Replicate:ProjectCharter');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:ProjectCharter');
    }
}
