<?php

declare(strict_types=1);

namespace App\Policies;

use App\Models\PerformanceCard;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Foundation\Auth\User as AuthUser;

class PerformanceCardPolicy
{
    use HandlesAuthorization;

    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:PerformanceCard');
    }

    public function view(AuthUser $authUser, PerformanceCard $performanceCard): bool
    {
        return $authUser->can('View:PerformanceCard');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:PerformanceCard');
    }

    public function update(AuthUser $authUser, PerformanceCard $performanceCard): bool
    {
        return $authUser->can('Update:PerformanceCard');
    }

    public function delete(AuthUser $authUser, PerformanceCard $performanceCard): bool
    {
        return $authUser->can('Delete:PerformanceCard');
    }

    public function restore(AuthUser $authUser, PerformanceCard $performanceCard): bool
    {
        return $authUser->can('Restore:PerformanceCard');
    }

    public function forceDelete(AuthUser $authUser, PerformanceCard $performanceCard): bool
    {
        return $authUser->can('ForceDelete:PerformanceCard');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:PerformanceCard');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:PerformanceCard');
    }

    public function replicate(AuthUser $authUser, PerformanceCard $performanceCard): bool
    {
        return $authUser->can('Replicate:PerformanceCard');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:PerformanceCard');
    }
}
