<?php

declare(strict_types=1);

namespace App\Policies;

use App\Models\Initiative;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Foundation\Auth\User as AuthUser;

class InitiativePolicy
{
    use HandlesAuthorization;

    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:Initiative');
    }

    public function view(AuthUser $authUser, Initiative $initiative): bool
    {
        return $authUser->can('View:Initiative');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:Initiative');
    }

    public function update(AuthUser $authUser, Initiative $initiative): bool
    {
        return $authUser->can('Update:Initiative');
    }

    public function delete(AuthUser $authUser, Initiative $initiative): bool
    {
        return $authUser->can('Delete:Initiative');
    }

    public function restore(AuthUser $authUser, Initiative $initiative): bool
    {
        return $authUser->can('Restore:Initiative');
    }

    public function forceDelete(AuthUser $authUser, Initiative $initiative): bool
    {
        return $authUser->can('ForceDelete:Initiative');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:Initiative');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:Initiative');
    }

    public function replicate(AuthUser $authUser, Initiative $initiative): bool
    {
        return $authUser->can('Replicate:Initiative');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:Initiative');
    }
}
