<?php

declare(strict_types=1);

namespace App\Policies;

use App\Models\GrantArea;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Foundation\Auth\User as AuthUser;

class GrantAreaPolicy
{
    use HandlesAuthorization;

    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:GrantArea');
    }

    public function view(AuthUser $authUser, GrantArea $grantArea): bool
    {
        return $authUser->can('View:GrantArea');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:GrantArea');
    }

    public function update(AuthUser $authUser, GrantArea $grantArea): bool
    {
        return $authUser->can('Update:GrantArea');
    }

    public function delete(AuthUser $authUser, GrantArea $grantArea): bool
    {
        return $authUser->can('Delete:GrantArea');
    }

    public function restore(AuthUser $authUser, GrantArea $grantArea): bool
    {
        return $authUser->can('Restore:GrantArea');
    }

    public function forceDelete(AuthUser $authUser, GrantArea $grantArea): bool
    {
        return $authUser->can('ForceDelete:GrantArea');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:GrantArea');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:GrantArea');
    }

    public function replicate(AuthUser $authUser, GrantArea $grantArea): bool
    {
        return $authUser->can('Replicate:GrantArea');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:GrantArea');
    }
}
