<?php

namespace App\Filament\Association\Resources\Orders\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ForceDeleteBulkAction;
use Filament\Actions\RestoreBulkAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Table;

class OrdersTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label(__('order.project_name'))
                    ->searchable()
                    ->sortable()
                    ->limit(50)
                    ->tooltip(function (TextColumn $column): ?string {
                        $state = $column->getState();

                        if (strlen($state) <= $column->getCharacterLimit()) {
                            return null;
                        }

                        return $state;
                    }),

                TextColumn::make('association.name')
                    ->label(__('order.association'))
                    ->searchable()
                    ->sortable()
                    ->toggleable(),

                TextColumn::make('grantArea.name')
                    ->label(__('order.grant_area'))
                    ->searchable()
                    ->sortable()
                    ->toggleable(),

                TextColumn::make('state.name')
                    ->label(__('order.state'))
                    ->searchable()
                    ->sortable()
                    ->toggleable(),

                TextColumn::make('city.name')
                    ->label(__('order.city'))
                    ->searchable()
                    ->sortable()
                    ->toggleable(),

                TextColumn::make('start_date')
                    ->label(__('order.start_date'))
                    ->date()
                    ->sortable()
                    ->toggleable(),

                TextColumn::make('duration_months')
                    ->label(__('order.duration'))
                    ->suffix(' '.__('order.months'))
                    ->sortable()
                    ->toggleable(),

                TextColumn::make('beneficiaries_count')
                    ->label(__('order.beneficiaries'))
                    ->numeric()
                    ->sortable()
                    ->toggleable(),

                TextColumn::make('total_amount')
                    ->label(__('order.total_amount'))
                    ->money('SAR')
                    ->sortable()
                    ->getStateUsing(fn ($record) => $record->total_amount)
                    ->toggleable(),

                TextColumn::make('deliverables_count')
                    ->label(__('order.deliverables_count'))
                    ->counts('deliverables')
                    ->sortable()
                    ->toggleable(),

                TextColumn::make('createdBy.name')
                    ->label(__('order.created_by'))
                    ->searchable()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('created_at')
                    ->label(__('order.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('updated_at')
                    ->label(__('order.updated_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('deleted_at')
                    ->label(__('order.deleted_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                TrashedFilter::make(),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ]);
    }
}
