<?php

namespace App\Filament\Admin\Resources\Users\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ForceDeleteBulkAction;
use Filament\Actions\RestoreBulkAction;
use Filament\Actions\ViewAction;
use Filament\Facades\Filament;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Table;

class UserTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')
                    ->label(__('common.id'))
                    ->sortable()
                    ->toggleable(),

                TextColumn::make('name')
                    ->label(__('common.name'))
                    ->sortable()
                    ->searchable(),

                TextColumn::make('email')
                    ->label(__('common.email'))
                    ->sortable()
                    ->searchable()
                    ->copyable(),

                TextColumn::make('phone')
                    ->label(__('common.phone'))
                    ->sortable()
                    ->searchable()
                    ->toggleable(),

                TextColumn::make('roles.name')
                    ->label(__('common.roles'))
                    ->badge()
                    ->separator(',')
                    ->toggleable(),

                TextColumn::make('orgs.name')
                    ->label(__('common.organizations'))
                    ->badge()
                    ->separator(',')
                    ->toggleable(),

                TextColumn::make('association_name')
                    ->label(__('common.association'))
                    ->getStateUsing(function ($record) {
                        $tenant = Filament::getTenant();
                        if (! $tenant) {
                            return null;
                        }

                        $association = $record->getAssociationInOrg($tenant);

                        return $association?->name;
                    })
                    ->placeholder(__('common.no_association'))
                    ->toggleable(),

                TextColumn::make('email_verified_at')
                    ->label(__('common.email_verified_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable()
                    ->toggledHiddenByDefault(),

                TextColumn::make('created_at')
                    ->label(__('common.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable()
                    ->toggledHiddenByDefault(),

                TextColumn::make('updated_at')
                    ->label(__('common.updated_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable()
                    ->toggledHiddenByDefault(),
            ])
            ->filters([
                TrashedFilter::make(),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ]);
    }
}
