<?php

namespace App\Filament\Admin\Resources\ProjectCharters\Schemas;

use App\Utils\ProgressBarRenderer;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;
use Illuminate\Support\HtmlString;

class ProjectCharterProgressInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make(__('project_charter.project_progress'))
                    ->icon('heroicon-o-chart-bar')
                    ->schema([
                        Grid::make(3)
                            ->schema([
                                // First Row: Phase, Status, Estimated Progress
                                TextEntry::make('phase')
                                    ->label(__('project_charter.project_phase'))
                                    ->badge(),

                                // TextEntry::make('project_status')
                                //     ->label(__('project_charter.status'))
                                //     ->badge()
                                //     ->color(fn ($record) => $record->project_status_color)
                                //     ->formatStateUsing(function ($state) {
                                //         return match ($state) {
                                //             'not_started' => __('project_charter.project_status_not_started'),
                                //             'in_progress' => __('project_charter.project_status_in_progress'),
                                //             'late' => __('project_charter.project_status_late'),
                                //             'done' => __('project_charter.project_status_done'),
                                //             default => $state,
                                //         };
                                //     }),

                                TextEntry::make('estimated_progress_percentage')
                                    ->label(__('project_charter.estimated_progress'))
                                    ->formatStateUsing(function ($state) {
                                        return number_format($state, 2).'%';
                                    })
                                    ->badge(),
                                // ->color(fn ($record) => $record->estimated_progress_color),
                            ]),

                        Grid::make(3)
                            ->schema([
                                // Second Row: Actual Progress, Financial Progress, Progress Deviation
                                TextEntry::make('project_progress')
                                    ->label(__('project_charter.project_completion_percentage'))
                                    ->formatStateUsing(fn (string $state): HtmlString => new HtmlString(ProgressBarRenderer::render($state, __('project_charter.project_completion_percentage')))),

                                TextEntry::make('financial_progress')
                                    ->label(__('project_charter.financial_completion_percentage'))
                                    ->formatStateUsing(fn (string $state): HtmlString => new HtmlString(ProgressBarRenderer::render($state, __('project_charter.financial_completion_percentage')))),

                                TextEntry::make('progress_deviation')
                                    ->label(__('project_charter.progress_deviation'))
                                    ->formatStateUsing(function ($state) {
                                        if (! is_numeric($state)) {
                                            return 'N/A';
                                        }
                                        $sign = $state >= 0 ? '+' : '';

                                        return $sign.number_format($state, 1).'%';
                                    })
                                    ->badge()
                                    ->color(fn ($record) => $record->progress_deviation_color),
                            ]),
                    ])
                    ->columnSpanFull(),
            ]);
    }
}
