<?php

namespace App\Filament\Admin\Resources\ProjectCharters\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;
use Illuminate\Support\HtmlString;

class ProjectCharterForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label(__('project_charter.name'))
                    ->required()
                    ->maxLength(255),

                Textarea::make('description')
                    ->label(__('project_charter.description'))
                    ->required()
                    ->columnSpanFull()
                    ->maxLength(10000),

                DatePicker::make('start_date')
                    ->label(__('project_charter.start_date'))
                    ->required(), // TODO: validate after or before end_date

                DatePicker::make('expected_end_date')
                    ->label(__('project_charter.expected_end_date'))
                    ->required()
                    ->after('start_date'),

                TextInput::make('total_cost')
                    ->label(__('project_charter.total_cost'))
                    ->required()
                    ->numeric()
                    ->default(0)
                    ->minValue(0)
                    ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                    ->helperText(__('project_charter.total_cost_helper')),
            ]);
    }
}
