<?php

namespace App\Filament\Admin\Resources\ProjectCharters;

use App\Filament\Admin\Resources\ProjectCharters\Pages\EditProjectCharter;
use App\Filament\Admin\Resources\ProjectCharters\Pages\ListProjectCharters;
use App\Filament\Admin\Resources\ProjectCharters\Pages\ManageProjectCharterFiles;
use App\Filament\Admin\Resources\ProjectCharters\Pages\ManageProjectRisks;
use App\Filament\Admin\Resources\ProjectCharters\Pages\ViewProgressProjectCharter;
use App\Filament\Admin\Resources\ProjectCharters\Pages\ViewProjectCharter;
use App\Filament\Admin\Resources\ProjectCharters\RelationManagers\DeliverablesRelationManager;
use App\Filament\Admin\Resources\ProjectCharters\RelationManagers\TasksRelationManager;
use App\Filament\Admin\Resources\ProjectCharters\Schemas\ProjectCharterForm;
use App\Filament\Admin\Resources\ProjectCharters\Schemas\ProjectCharterInfolist;
use App\Filament\Admin\Resources\ProjectCharters\Tables\ProjectChartersTable;
use App\Models\ProjectCharter;
use BackedEnum;
use Filament\Pages\Enums\SubNavigationPosition;
use Filament\Pages\Page;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ProjectCharterResource extends Resource
{
    protected static ?string $model = ProjectCharter::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::DocumentText;

    protected static ?int $navigationSort = 3;

    protected static ?string $recordTitleAttribute = 'name';

    protected static ?SubNavigationPosition $subNavigationPosition = SubNavigationPosition::Top;

    public static function getNavigationLabel(): string
    {
        return __('project_charter.project_charters');
    }

    public static function getModelLabel(): string
    {
        return __('project_charter.project_charter');
    }

    public static function getPluralModelLabel(): string
    {
        return __('project_charter.project_charters');
    }

    public static function form(Schema $schema): Schema
    {
        return ProjectCharterForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ProjectCharterInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ProjectChartersTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            DeliverablesRelationManager::class,
            TasksRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListProjectCharters::route('/'),
            'edit' => EditProjectCharter::route('/{record}/edit'),
            'view' => ViewProjectCharter::route('/{record}'),
            'progress' => ViewProgressProjectCharter::route('/{record}/progress'),
            'risks' => ManageProjectRisks::route('/{record}/risks'),
            'files' => ManageProjectCharterFiles::route('/{record}/files'),
        ];
    }

    public static function getRecordSubNavigation(Page $page): array
    {
        $navigationItems = [
            ViewProjectCharter::class,
        ];

        if ($page->record?->shouldShowProgressView()) {
            $navigationItems[] = ViewProgressProjectCharter::class;
            // $navigationItems[] = ManageProjectGovernance::class;
            $navigationItems[] = ManageProjectRisks::class;
        }

        // Files management is available for all statuses
        $navigationItems[] = ManageProjectCharterFiles::class;

        return $page->generateNavigationItems($navigationItems);
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }

    public static function getNavigationGroup(): ?string
    {
        return __('common.navigation.group.projects');
    }
}
