<?php

namespace App\Filament\Admin\Resources\ProjectCharters\Pages;

use App\Filament\Admin\Resources\ProjectCharters\ProjectCharterResource;
use App\Workflows\Actions\WorkflowActions;
use Filament\Actions\EditAction;
use Filament\Resources\Pages\ViewRecord;

class ViewProjectCharter extends ViewRecord
{
    protected static string $resource = ProjectCharterResource::class;

    public function mount(int|string $record): void
    {
        parent::mount($record);

        // Auto-initialize workflow if none exists
        WorkflowActions::autoInitializeWorkflow($this->record);
    }

    protected function getHeaderActions(): array
    {
        return [
            EditAction::make(),
            ...WorkflowActions::getActions($this->record, fn ($keys) => $this->refreshFormData($keys)),

        ];
    }

    protected function getAllRelationManagers(): array
    {
        return [];
    }
}
