<?php

namespace App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Resources\ProjectCharters\Schemas;

use App\Models\ProjectCharter;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;
use Illuminate\Support\HtmlString;

class ProjectCharterForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                // TODO: order id

                // Preselect initiative project if provided in the request
                Hidden::make('initiative_project_id')
                    ->default(fn (?ProjectCharter $record): ?int => $record?->initiative_project_id ?? request()->get('initiative_project_id')),

                // Show initiative project selection if not preselected
                Select::make('initiative_project_id')
                    ->label(__('project_charter.project_charter'))
                    ->relationship('initiativeProject', 'name')
                    ->required()
                    ->searchable()
                    ->preload()
                    ->visible(false),

                TextInput::make('name')
                    ->label(__('project_charter.name'))
                    ->required()
                    ->maxLength(255),

                Textarea::make('description')
                    ->label(__('project_charter.description'))
                    ->required()
                    ->columnSpanFull()
                    ->maxLength(10000),

                DatePicker::make('start_date')
                    ->label(__('project_charter.start_date'))
                    ->required(), // TODO: validate after or before end_date

                DatePicker::make('expected_end_date')
                    ->label(__('project_charter.expected_end_date'))
                    ->required()
                    ->after('start_date'),

                TextInput::make('total_cost')
                    ->label(__('project_charter.total_cost'))
                    ->required()
                    ->numeric()
                    ->default(0)
                    ->minValue(0)
                    ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                    ->helperText(__('project_charter.total_cost_helper')),
            ]);
    }
}
