<?php

namespace App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Resources\ProjectCharters;

use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\InitiativeResource;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Resources\ProjectCharters\Pages\CreateProjectCharter;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Resources\ProjectCharters\Schemas\ProjectCharterForm;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Resources\ProjectCharters\Schemas\ProjectCharterInfolist;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Resources\ProjectCharters\Tables\ProjectChartersTable;
use App\Models\ProjectCharter;
use BackedEnum;
use Filament\Resources\ParentResourceRegistration;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ProjectCharterResource extends Resource
{
    protected static ?string $model = ProjectCharter::class;

    protected static bool $isScopedToTenant = false; // disabled since it is nested under InitiativeResource

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $recordTitleAttribute = 'name';

    public static function getParentResourceRegistration(): ?ParentResourceRegistration
    {
        return InitiativeResource::asParent()
            ->relationship('charters')
            ->inverseRelationship('initiative');
    }

    public static function form(Schema $schema): Schema
    {
        return ProjectCharterForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ProjectCharterInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ProjectChartersTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'create' => CreateProjectCharter::route('/create'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
