<?php

namespace App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives;

use App\Filament\Admin\Resources\PerformanceCards\PerformanceCardResource;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Pages\CreateInitiative;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Pages\EditInitiative;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Pages\ManageProjectCharters;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Pages\ViewInitiative;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\RelationManagers\ProjectsRelationManager;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Schemas\InitiativeForm;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Schemas\InitiativeInfolist;
use App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Tables\InitiativesTable;
use App\Models\Initiative;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class InitiativeResource extends Resource
{
    protected static ?string $model = Initiative::class;

    protected static bool $isScopedToTenant = false; // disabled since it is nested under PerformanceCard

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $parentResource = PerformanceCardResource::class;

    protected static ?string $recordTitleAttribute = 'name';

    public static function getNavigationLabel(): string
    {
        return __('initiative.initiatives');
    }

    public static function getModelLabel(): string
    {
        return __('initiative.initiative');
    }

    public static function getPluralModelLabel(): string
    {
        return __('initiative.initiatives');
    }

    public function getTitle(): string
    {
        return __('initiative.initiatives');
    }

    public static function form(Schema $schema): Schema
    {
        return InitiativeForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return InitiativeInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return InitiativesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            ProjectsRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'create' => CreateInitiative::route('/create'),
            'view' => ViewInitiative::route('/{record}'),
            'edit' => EditInitiative::route('/{record}/edit'),
            'project-charters' => ManageProjectCharters::route('/{record}/project-charters'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
