<?php

namespace App\Filament\Admin\Resources\PerformanceCards;

use App\Filament\Admin\Resources\PerformanceCards\Forms\PerformanceCardForm;
use App\Filament\Admin\Resources\PerformanceCards\Pages\CreatePerformanceCard;
use App\Filament\Admin\Resources\PerformanceCards\Pages\EditPerformanceCard;
use App\Filament\Admin\Resources\PerformanceCards\Pages\ListPerformanceCards;
use App\Filament\Admin\Resources\PerformanceCards\Pages\ManageInitiatives;
use App\Filament\Admin\Resources\PerformanceCards\Pages\ViewPerformanceCard;
use App\Filament\Admin\Resources\PerformanceCards\Pages\ViewPerformanceWallet;
use App\Filament\Admin\Resources\PerformanceCards\Tables\PerformanceCardTable;
use App\Models\PerformanceCard;
use Filament\Pages\Enums\SubNavigationPosition;
use Filament\Resources\Pages\Page;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PerformanceCardResource extends Resource
{
    protected static ?string $model = PerformanceCard::class;

    protected static string|\BackedEnum|null $navigationIcon = Heroicon::DocumentChartBar;

    protected static ?int $navigationSort = 2;

    protected static ?SubNavigationPosition $subNavigationPosition = SubNavigationPosition::Top;

    public static function getNavigationLabel(): string
    {
        return __('performance_card.performance_cards');
    }

    public static function getModelLabel(): string
    {
        return __('performance_card.performance_card');
    }

    public static function getPluralModelLabel(): string
    {
        return __('performance_card.performance_cards');
    }

    public static function form(Schema $schema): Schema
    {
        return PerformanceCardForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return PerformanceCardTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListPerformanceCards::route('/'),
            'create' => CreatePerformanceCard::route('/create'),
            'view' => ViewPerformanceCard::route('/{record}'),
            'edit' => EditPerformanceCard::route('/{record}/edit'),
            'wallet' => ViewPerformanceWallet::route('/{record}/wallet'),
            'initiatives' => ManageInitiatives::route('/{record}/initiatives'),

        ];
    }

    public static function getRecordSubNavigation(Page $page): array
    {
        $navigationItems = [
            Pages\ViewPerformanceCard::class,
        ];

        if ($page->getRecord()->wallet) {
            $navigationItems[] = ViewPerformanceWallet::class;
            $navigationItems[] = ManageInitiatives::class;
        }

        return $page->generateNavigationItems($navigationItems);
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }

    public static function getNavigationGroup(): ?string
    {
        return __('common.navigation.group.projects');
    }
}
