<?php

namespace App\Filament\Admin\Resources\PerformanceCards\Forms;

use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Components\Flex;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;
use Filament\Support\Enums\FontWeight;

class PerformanceWalletInfolist
{
    public static function make(Schema $schema): Schema
    {
        return $schema
            ->components([
                // Check if wallet exists
                Section::make(__('performance_card.no_wallet_section'))
                    ->icon('heroicon-o-exclamation-triangle')
                    ->schema([
                        TextEntry::make('no_wallet_message')
                            ->label(__('performance_card.performance_wallet'))
                            ->getStateUsing(fn () => __('performance_card.no_wallet_created'))
                            ->color('warning')
                            ->icon('heroicon-o-minus-circle')
                            ->columnSpanFull(),
                    ])
                    ->visible(fn ($record) => ! $record->wallet),

                // Wallet exists - show full details
                Flex::make([
                    // Left Column - Basic Wallet Information
                    Grid::make(1)
                        ->schema([
                            // Basic Wallet Information
                            Section::make(__('performance_wallet.basic_information'))
                                ->icon('heroicon-o-wallet')
                                ->schema([
                                    Grid::make(2)
                                        ->schema([
                                            TextEntry::make('wallet.name')
                                                ->label(__('performance_wallet.name'))
                                                ->icon('heroicon-o-wallet')
                                                ->color('primary')
                                                ->weight(FontWeight::SemiBold),

                                            TextEntry::make('wallet.start_date')
                                                ->label(__('performance_wallet.start_date'))
                                                ->icon('heroicon-o-calendar')
                                                ->date()
                                                ->color('success'),
                                        ]),

                                    Grid::make(2)
                                        ->schema([
                                            TextEntry::make('wallet.expected_end_date')
                                                ->label(__('performance_wallet.expected_end_date'))
                                                ->icon('heroicon-o-calendar')
                                                ->date()
                                                ->color('warning'),

                                            TextEntry::make('wallet.createdBy.name')
                                                ->label(__('common.created_by'))
                                                ->icon('heroicon-o-user')
                                                ->color('gray')
                                                ->getStateUsing(fn ($record) => $record->wallet?->createdBy?->name),
                                        ]),

                                    TextEntry::make('wallet.description')
                                        ->label(__('performance_wallet.description'))
                                        ->prose()
                                        ->markdown()
                                        ->visible(fn ($record) => $record->wallet?->description)
                                        ->columnSpanFull(),
                                ]),

                            // Related Performance Card Information
                            Section::make(__('performance_wallet.related_performance_card'))
                                ->icon('heroicon-o-clipboard-document-list')
                                ->schema([
                                    Grid::make(2)
                                        ->schema([
                                            TextEntry::make('goal')
                                                ->label(__('performance_card.goal'))
                                                ->prose()
                                                ->markdown()
                                                ->columnSpanFull(),

                                            TextEntry::make('org.name')
                                                ->label(__('common.organization'))
                                                ->icon('heroicon-o-building-office')
                                                ->color('primary'),

                                            TextEntry::make('department.name')
                                                ->label(__('common.department'))
                                                ->icon('heroicon-o-building-office-2')
                                                ->color('gray'),
                                        ]),
                                ]),
                        ]),

                    // Right Column - Wallet Metadata & Timestamps
                    Grid::make(1)
                        ->schema([
                            // Wallet Timestamps
                            Section::make(__('performance_wallet.timestamps'))
                                ->icon('heroicon-o-clock')
                                ->schema([
                                    Grid::make(2)
                                        ->schema([
                                            TextEntry::make('wallet.created_at')
                                                ->label(__('common.created_at'))
                                                ->icon('heroicon-o-calendar')
                                                ->dateTime()
                                                ->color('success'),

                                            TextEntry::make('wallet.updated_at')
                                                ->label(__('common.last_updated'))
                                                ->icon('heroicon-o-pencil-square')
                                                ->dateTime()
                                                ->color('gray'),
                                        ]),

                                    Grid::make(2)
                                        ->schema([
                                            TextEntry::make('wallet.deleted_at')
                                                ->label(__('common.deleted_at'))
                                                ->icon('heroicon-o-trash')
                                                ->dateTime()
                                                ->color('danger')
                                                ->visible(fn ($record) => $record->wallet?->deleted_at),

                                            TextEntry::make('wallet.id')
                                                ->label(__('performance_wallet.wallet_id'))
                                                ->icon('heroicon-o-hashtag')
                                                ->color('gray')
                                                ->copyable(),
                                        ]),
                                ]),

                            // Performance Card Context
                            Section::make(__('performance_card.context'))
                                ->icon('heroicon-o-information-circle')
                                ->schema([
                                    Grid::make(2)
                                        ->schema([
                                            TextEntry::make('project_manner')
                                                ->label(__('performance_card.project_manner'))
                                                ->badge()
                                                ->color(fn ($state) => match ($state?->value) {
                                                    'individual' => 'success',
                                                    'collaborative' => 'warning',
                                                    default => 'gray'
                                                })
                                                ->formatStateUsing(fn ($state) => $state?->getLabel()),

                                            TextEntry::make('createdBy.name')
                                                ->label(__('performance_card.card_created_by'))
                                                ->icon('heroicon-o-user')
                                                ->color('gray')
                                                ->getStateUsing(fn ($record) => $record->createdBy?->name),
                                        ]),

                                    Grid::make(2)
                                        ->schema([
                                            TextEntry::make('created_at')
                                                ->label(__('performance_card.card_created_at'))
                                                ->icon('heroicon-o-clock')
                                                ->dateTime()
                                                ->color('gray'),

                                            TextEntry::make('id')
                                                ->label(__('performance_card.card_id'))
                                                ->icon('heroicon-o-hashtag')
                                                ->color('gray')
                                                ->copyable(),
                                        ]),
                                ]),
                        ]),
                ])->from('md')
                    ->columnSpanFull()
                    ->visible(fn ($record) => $record->wallet),
            ]);
    }
}
