<?php

namespace App\Filament\Admin\Resources\PerformanceCards\Forms;

use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Components\Flex;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;
use Filament\Support\Enums\FontWeight;

class PerformanceCardInfolist
{
    public static function make(Schema $schema): Schema
    {
        return $schema
            ->components([
                Flex::make([
                    // Left Column - Main Performance Card Information
                    Grid::make(1)
                        ->schema([
                            // Basic Information Card
                            Section::make(__('performance_card.basic_information'))
                                ->icon('heroicon-o-clipboard-document-list')
                                ->schema([
                                    Grid::make(2)
                                        ->schema([
                                            TextEntry::make('org.name')
                                                ->label(__('common.organization'))
                                                ->icon('heroicon-o-building-office')
                                                ->color('primary')
                                                ->weight(FontWeight::SemiBold),

                                            TextEntry::make('department.name')
                                                ->label(__('common.department'))
                                                ->icon('heroicon-o-building-office-2')
                                                ->color('gray'),
                                        ]),

                                    Grid::make(1)
                                        ->schema([
                                            TextEntry::make('project_manner')
                                                ->label(__('performance_card.project_manner'))
                                                ->badge()
                                                ->color(fn ($state) => match ($state?->value) {
                                                    'individual' => 'success',
                                                    'collaborative' => 'warning',
                                                    default => 'gray'
                                                })
                                                ->formatStateUsing(fn ($state) => $state?->getLabel()),

                                            TextEntry::make('goal')
                                                ->label(__('performance_card.goal'))
                                                ->prose()
                                                ->markdown()
                                                ->columnSpanFull(),
                                        ]),
                                ]),

                            // Grant Areas Card
                            Section::make(__('performance_card.grant_areas'))
                                ->icon('heroicon-o-squares-plus')
                                ->schema([
                                    TextEntry::make('grantAreas.name')
                                        ->label(__('performance_card.associated_grant_areas'))
                                        ->badge()
                                        ->color('info')
                                        ->visible(fn ($record) => $record->grantAreas->isNotEmpty())
                                        ->columnSpanFull(),

                                    TextEntry::make('no_grant_areas')
                                        ->label(__('performance_card.grant_areas'))
                                        ->getStateUsing(fn () => __('performance_card.no_grant_areas_assigned'))
                                        ->color('gray')
                                        ->icon('heroicon-o-minus-circle')
                                        ->visible(fn ($record) => $record->grantAreas->isEmpty())
                                        ->columnSpanFull(),
                                ]),

                            // Team Assignments Card
                            Section::make(__('performance_card.team_assignments'))
                                ->icon('heroicon-o-users')
                                ->schema([
                                    TextEntry::make('assignees_count')
                                        ->label(__('performance_card.assigned_members'))
                                        ->getStateUsing(fn ($record) => $record->assignees()->count())
                                        ->badge()
                                        ->color('success')
                                        ->icon('heroicon-o-user-group')
                                        ->visible(fn ($record) => $record->assignees()->count() > 0),

                                    TextEntry::make('assignees.name')
                                        ->label(__('performance_card.team_members'))
                                        ->listWithLineBreaks()
                                        ->bulleted()
                                        ->visible(fn ($record) => $record->assignees()->count() > 0)
                                        ->columnSpanFull(),

                                    TextEntry::make('no_assignees')
                                        ->label(__('performance_card.team_assignments'))
                                        ->getStateUsing(fn () => __('performance_card.no_team_assigned'))
                                        ->color('gray')
                                        ->icon('heroicon-o-minus-circle')
                                        ->visible(fn ($record) => $record->assignees()->count() === 0)
                                        ->columnSpanFull(),
                                ]),
                        ]),

                    // Right Column - Performance Data & Results
                    Grid::make(1)
                        ->schema([
                            // Results Card
                            Section::make(__('performance_card.results'))
                                ->icon('heroicon-o-chart-bar-square')
                                ->schema([
                                    TextEntry::make('results_count')
                                        ->label(__('performance_card.total_results'))
                                        ->getStateUsing(fn ($record) => $record->results()->count())
                                        ->badge()
                                        ->color('info')
                                        ->icon('heroicon-o-list-bullet')
                                        ->visible(fn ($record) => $record->results()->count() > 0),

                                    TextEntry::make('results.name')
                                        ->label(__('performance_card.results'))
                                        ->listWithLineBreaks()
                                        ->bulleted()
                                        ->visible(fn ($record) => $record->results()->count() > 0)
                                        ->columnSpanFull(),

                                    TextEntry::make('no_results')
                                        ->label(__('performance_card.results'))
                                        ->getStateUsing(fn () => __('performance_card.no_results_recorded'))
                                        ->color('gray')
                                        ->icon('heroicon-o-minus-circle')
                                        ->visible(fn ($record) => $record->results()->count() === 0)
                                        ->columnSpanFull(),
                                ]),

                            // Creation Information Card
                            Section::make(__('common.creation_info'))
                                ->icon('heroicon-o-information-circle')
                                ->schema([
                                    Grid::make(2)
                                        ->schema([
                                            TextEntry::make('createdBy.name')
                                                ->label(__('common.created_by'))
                                                ->icon('heroicon-o-user')
                                                ->color('gray'),

                                            TextEntry::make('created_at')
                                                ->label(__('common.created_at'))
                                                ->icon('heroicon-o-clock')
                                                ->dateTime()
                                                ->color('gray'),
                                        ]),

                                    Grid::make(2)
                                        ->schema([
                                            TextEntry::make('updated_at')
                                                ->label(__('common.last_updated'))
                                                ->icon('heroicon-o-pencil-square')
                                                ->dateTime()
                                                ->color('gray'),

                                            TextEntry::make('id')
                                                ->label(__('common.id'))
                                                ->icon('heroicon-o-hashtag')
                                                ->color('gray')
                                                ->copyable(),
                                        ]),
                                ]),
                        ]),
                ])->from('md')
                    ->columnSpanFull(),
            ]);
    }
}
