<?php

namespace App\Filament\Admin\Resources\GrantAreas;

use App\Filament\Admin\Resources\GrantAreas\Forms\GrantAreaForm;
use App\Filament\Admin\Resources\GrantAreas\Pages\CreateGrantArea;
use App\Filament\Admin\Resources\GrantAreas\Pages\EditGrantArea;
use App\Filament\Admin\Resources\GrantAreas\Pages\ListGrantAreas;
use App\Filament\Admin\Resources\GrantAreas\Pages\ViewGrantArea;
use App\Filament\Admin\Resources\GrantAreas\Tables\GrantAreaTable;
use App\Models\GrantArea;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class GrantAreaResource extends Resource
{
    protected static ?string $model = GrantArea::class;

    protected static string|\BackedEnum|null $navigationIcon = 'heroicon-o-cog-6-tooth';

    protected static ?int $navigationSort = 6;

    public static function getNavigationLabel(): string
    {
        return __('grant_area.grant_areas');
    }

    public static function getModelLabel(): string
    {
        return __('grant_area.grant_area');
    }

    public static function getPluralModelLabel(): string
    {
        return __('grant_area.grant_areas');
    }

    public static function form(Schema $schema): Schema
    {
        return GrantAreaForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return GrantAreaTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListGrantAreas::route('/'),
            'create' => CreateGrantArea::route('/create'),
            'view' => ViewGrantArea::route('/{record}'),
            'edit' => EditGrantArea::route('/{record}/edit'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }

    public static function getNavigationGroup(): ?string
    {
        return __('common.navigation.group.organization');
    }
}
