<?php

namespace App\Filament\Admin\Resources\DonorPortfolios\Forms;

use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class DonorPortfolioForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make(__('donor_portfolio.donor_portfolio_information'))
                    ->description(__('donor_portfolio.donor_portfolio_information_description'))
                    ->schema([
                        TextInput::make('name')
                            ->label(__('donor_portfolio.name'))
                            ->placeholder(__('donor_portfolio.portfolio_name_placeholder'))
                            ->maxLength(255)
                            ->required()
                            ->unique(modifyRuleUsing: function ($rule, $get) {
                                // Make unique within the current organization
                                return $rule->where('org_id', filament()->getTenant()?->id);
                            }),

                        TextInput::make('balance')
                            ->label(__('donor_portfolio.balance'))
                            ->placeholder(__('donor_portfolio.balance_placeholder'))
                            ->numeric()
                            ->step(0.01)
                            ->minValue(0)
                            ->default(0.00)
                            ->prefix('SAR')
                            ->required(),
                    ])
                    ->columns(2),
            ]);
    }
}
