<?php

namespace App\Filament\Admin\Resources\DonorPortfolios;

use App\Filament\Admin\Resources\DonorPortfolios\Forms\DonorPortfolioForm;
use App\Filament\Admin\Resources\DonorPortfolios\Pages\CreateDonorPortfolio;
use App\Filament\Admin\Resources\DonorPortfolios\Pages\EditDonorPortfolio;
use App\Filament\Admin\Resources\DonorPortfolios\Pages\ListDonorPortfolios;
use App\Filament\Admin\Resources\DonorPortfolios\Pages\ViewDonorPortfolio;
use App\Filament\Admin\Resources\DonorPortfolios\Tables\DonorPortfolioTable;
use App\Models\DonorPortfolio;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class DonorPortfolioResource extends Resource
{
    protected static ?string $model = DonorPortfolio::class;

    protected static string|\BackedEnum|null $navigationIcon = 'heroicon-o-banknotes';

    protected static ?int $navigationSort = 3;

    public static function getNavigationLabel(): string
    {
        return __('donor_portfolio.donor_portfolios');
    }

    public static function getModelLabel(): string
    {
        return __('donor_portfolio.donor_portfolio');
    }

    public static function getPluralModelLabel(): string
    {
        return __('donor_portfolio.donor_portfolios');
    }

    public static function form(Schema $schema): Schema
    {
        return DonorPortfolioForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return DonorPortfolioTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListDonorPortfolios::route('/'),
            'create' => CreateDonorPortfolio::route('/create'),
            'view' => ViewDonorPortfolio::route('/{record}'),
            'edit' => EditDonorPortfolio::route('/{record}/edit'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }

    public static function getNavigationGroup(): ?string
    {
        return __('common.navigation.group.organization');
    }
}
