<?php

namespace App\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum ProjectCharterPhase: string implements HasColor, HasLabel
{
    case INITIATION = 'initiation';
    case EXECUTION = 'execution';
    case CLOSURE = 'closure';

    public function getLabel(): ?string
    {
        return __('project_charter.phase.'.$this->value);
    }

    public function getColor(): string|array|null
    {
        return match ($this) {
            self::INITIATION => 'warning',
            self::EXECUTION => 'gray',
            self::CLOSURE => 'danger',
        };
    }

    public static function getOptions(): array
    {
        return collect(self::cases())->mapWithKeys(fn ($case) => [
            $case->value => $case->getLabel(),
        ])->toArray();
    }
}
